/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBRegisto;
import fme.CFLib;
import fme.CFType_Data;
import fme.CHCampo_Combo;
import fme.CHCampo_Opt;
import fme.CHCampo_Text;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_Proj_1;
import fme._lib;
import fme.fmeApp;
import java.util.Date;

class CBRegisto_DadosProjecto
extends CBRegisto {
    public Frame_Proj_1 P07;

    public String getPagina() {
        return "Proj_1";
    }

    CBRegisto_DadosProjecto() {
        this.tag = "DadosProjecto";
        this.P07 = (Frame_Proj_1)fmeApp.Paginas.getPage("Proj_1");
        if (this.P07 == null) {
            return;
        }
        this.started = true;
        this.Campos.add(new CHCampo_Text("acronimo", this.P07.getJTextField_Acronimo(), null, this));
        this.Campos.add(new CHCampo_Text("designacao", this.P07.getJTextField_Designacao(), null, this));
        this.Campos.add(new CHCampo_Combo("regime_op", "RegimeOperacao", this.P07.getJComboBox_RegimeOperacao(), (CBRegisto)this));
        CHCampo_Opt opt_c = new CHCampo_Opt("simplex", this);
        opt_c.setOptions("S", "N");
        opt_c.addComponent(this.P07.getJCheckBox_SimplexSim());
        opt_c.addComponent(this.P07.getJCheckBox_SimplexNao());
        opt_c.dummy = this.P07.jCheckBox_SimplexClear;
        this.Campos.add(opt_c);
        CHCampo_Opt opt_c17 = new CHCampo_Opt("simplex2017", this);
        opt_c17.setOptions("S", "N");
        opt_c17.addComponent(this.P07.getJCheckBox_Simplex2017Sim());
        opt_c17.addComponent(this.P07.getJCheckBox_Simplex2017Nao());
        opt_c17.dummy = this.P07.jCheckBox_Simplex2017Clear;
        this.Campos.add(opt_c17);
        CHCampo_Opt opt_c18 = new CHCampo_Opt("simplex2018", this);
        opt_c18.setOptions("S", "N");
        opt_c18.addComponent(this.P07.getJCheckBox_Simplex2018Sim());
        opt_c18.addComponent(this.P07.getJCheckBox_Simplex2018Nao());
        opt_c18.dummy = this.P07.jCheckBox_Simplex2018Clear;
        this.Campos.add(opt_c18);
        this.Campos.add(new CHCampo_Text("dt_inicio", this.P07.getJTextField_Inicio(), CFLib.VLD_DATA, this));
        this.Campos.add(new CHCampo_Text("n_meses", this.P07.getJTextField_Meses(), CFLib.VLD_VALOR_S, this));
        this.Campos.add(new CHCampo_Text("dt_fim", this.P07.getJTextField_Fim(), CFLib.VLD_DATA, this));
        this.Campos.add(new CHCampo_Text("inv_geral", this.P07.getJTextField_InvOutros(), CFLib.VLD_VALOR, null));
        this.Campos.add(new CHCampo_Text("inv_pessoal", this.P07.getJTextField_InvPessoal(), CFLib.VLD_VALOR, null));
        this.Campos.add(new CHCampo_Text("inv_fse", this.P07.getJTextField_InvFSE(), CFLib.VLD_VALOR, null));
        this.Campos.add(new CHCampo_Text("investimento", this.P07.getJTextField_InvTotal(), CFLib.VLD_VALOR, null));
        CHCampo_Opt opt_f = new CHCampo_Opt("formacao", this);
        opt_f.setOptions("S", "N");
        opt_f.addComponent(this.P07.getJCheckBox_Sim());
        opt_f.addComponent(this.P07.getJCheckBox_Nao());
        opt_f.dummy = this.P07.jCheckBox_FormacaoClear;
        this.Campos.add(opt_f);
    }

    void on_update(String tag) {
        if (tag.equals("dt_inicio") || tag.equals("dt_fim")) {
            String dt_inicio = this.getByName((String)"dt_inicio").v;
            String dt_fim = this.getByName((String)"dt_fim").v;
            if (dt_inicio.length() == 0 || dt_fim.length() == 0 || dt_fim.compareTo(dt_inicio) < 0) {
                this.getByName("n_meses").setStringValue("");
                return;
            }
            this.getByName("n_meses").setStringValue(Double.toString(this.n_meses(dt_inicio, dt_fim)));
        }
    }

    double n_meses(String dt_inicio, String dt_fim) {
        int ano_i = Integer.parseInt(dt_inicio.substring(0, 4));
        int ano_f = Integer.parseInt(dt_fim.substring(0, 4));
        int mes_i = Integer.parseInt(dt_inicio.substring(5, 7));
        int mes_f = Integer.parseInt(dt_fim.substring(5, 7));
        int dia_i = Integer.parseInt(dt_inicio.substring(8, 10));
        int dia_f = Integer.parseInt(dt_fim.substring(8, 10));
        double n_meses = (ano_f - ano_i) * 12 + (mes_f - mes_i - 1);
        double mes = mes_i;
        double d = 0.0;
        if (mes == 1.0 || mes == 3.0 || mes == 5.0 || mes == 7.0 || mes == 8.0 || mes == 10.0 || mes == 12.0) {
            d = 31.0;
        }
        if (mes == 4.0 || mes == 6.0 || mes == 9.0 || mes == 11.0) {
            d = 30.0;
        }
        if (mes == 2.0 && ano_i % 4 == 0) {
            d = 29.0;
        }
        if (mes == 2.0 && ano_i % 4 != 0) {
            d = 28.0;
        }
        n_meses += (d - (double)dia_i + 1.0) / d;
        mes = mes_f;
        if (mes == 1.0 || mes == 3.0 || mes == 5.0 || mes == 7.0 || mes == 8.0 || mes == 10.0 || mes == 12.0) {
            d = 31.0;
        }
        if (mes == 4.0 || mes == 6.0 || mes == 9.0 || mes == 11.0) {
            d = 30.0;
        }
        if (mes == 2.0 && ano_f % 4 == 0) {
            d = 29.0;
        }
        if (mes == 2.0 && ano_f % 4 != 0) {
            d = 28.0;
        }
        return n_meses += (double)dia_f / d;
    }

    String on_xml(String tag) {
        String s = "";
        if (tag.equals("regime_op")) {
            String c = this.getByName(tag).getStringValue();
            s = c.length() == 0 ? String.valueOf(s) + "<regime_op_d/>\n" : String.valueOf(s) + _lib.xml_encode("regime_op_d", CTabelas.RegimeOperacao.getDesign(c));
        }
        return s;
    }

    CHValid_Grp validar_1(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Descri\u00e7\u00e3o e Tipologia");
        }
        this.extract();
        if (this.getByName("designacao").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("designacao", "Designa\u00e7\u00e3o - %o"));
        }
        if (this.getByName("regime_op").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("regime_op", "Regime/Opera\u00e7\u00e3o - %o"));
        } else if (!CBData.regime_op.equals("") && !this.getByName((String)"regime_op").v.substring(0, 2).matches(CBData.regime_op)) {
            err_list.add_msg(new CHValid_Msg("tipol_assoc", "Regime/Opera\u00e7\u00e3o - op\u00e7\u00e3o inv\u00e1lida, s\u00f3 s\u00e3o permitidas candidaturas ao regime geral"));
        }
        CBData.Subprojecto.validar(err_list);
        if (this.getByName("simplex").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("simplex", "O projeto est\u00e1 inserido nas medidas Simplex 2016? - %o"));
        } else {
            if (this.getByName((String)"simplex").v.equals("S") && CBData.MedidasSimplex.isEmpty()) {
                err_list.add_msg(new CHValid_Msg("simplex", "Em caso afirmativo, indique a(s) medida(s) Simplex 2016 em que se insere - %o"));
            }
            if (this.getByName((String)"simplex").v.equals("N") && !CBData.MedidasSimplex.isEmpty()) {
                err_list.add_msg(new CHValid_Msg("simplex", "Em caso afirmativo, indique a(s) medida(s) Simplex 2016 em que se insere - Neste Caso N\u00e3o Preenche"));
            }
            if (!CBData.MedidasSimplex.isUnique("m_simplex")) {
                err_list.add_msg(new CHValid_Msg("simplex", "Medidas Simplex 2016 - N\u00e3o podem existir medidas repetidas"));
            }
        }
        if (this.getByName("simplex2017").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("simplex2017", "O projeto est\u00e1 inserido nas medidas Simplex 2017? - %o"));
        } else {
            if (this.getByName((String)"simplex2017").v.equals("S") && CBData.MedidasSimplex2017.isEmpty()) {
                err_list.add_msg(new CHValid_Msg("simplex2017", "Em caso afirmativo, indique a(s) medida(s) Simplex 2017 em que se insere - %o"));
            }
            if (this.getByName((String)"simplex2017").v.equals("N") && !CBData.MedidasSimplex2017.isEmpty()) {
                err_list.add_msg(new CHValid_Msg("simplex2017", "Em caso afirmativo, indique a(s) medida(s) Simplex 2017 em que se insere - Neste Caso N\u00e3o Preenche"));
            }
            if (!CBData.MedidasSimplex2017.isUnique("m_simplex")) {
                err_list.add_msg(new CHValid_Msg("simplex", "Medidas Simplex 2017 - N\u00e3o podem existir medidas repetidas"));
            }
        }
        if (this.getByName("simplex2018").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("simplex2018", "O projeto est\u00e1 inserido nas medidas Simplex 2018? - %o"));
        } else {
            if (this.getByName((String)"simplex2018").v.equals("S") && CBData.MedidasSimplex2018.isEmpty()) {
                err_list.add_msg(new CHValid_Msg("simplex2018", "Em caso afirmativo, indique a(s) medida(s) Simplex 2018 em que se insere - %o"));
            }
            if (this.getByName((String)"simplex2018").v.equals("N") && !CBData.MedidasSimplex2018.isEmpty()) {
                err_list.add_msg(new CHValid_Msg("simplex2018", "Em caso afirmativo, indique a(s) medida(s) Simplex 2018 em que se insere - Neste Caso N\u00e3o Preenche"));
            }
            if (!CBData.MedidasSimplex2018.isUnique("m_simplex")) {
                err_list.add_msg(new CHValid_Msg("simplex", "Medidas Simplex 2018 - N\u00e3o podem existir medidas repetidas"));
            }
        }
        return err_list;
    }

    CHValid_Grp validar_2(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Calendariza\u00e7\u00e3o");
        }
        this.extract();
        if (this.getByName("dt_inicio").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("dt_inicio", "Data de In\u00edcio da Opera\u00e7\u00e3o - %o"));
        } else if (this.getByName((String)"dt_inicio").v.compareTo("2014-01-01") < 0) {
            err_list.add_msg(new CHValid_Msg("dt_inicio", "Data de In\u00edcio da Opera\u00e7\u00e3o n\u00e3o pode ser anterior a 2014-01-01"));
        }
        if (this.getByName("dt_fim").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("dt_fim", "Data de Fim da Opera\u00e7\u00e3o - %o"));
        } else if (this.getByName((String)"dt_fim").v.compareTo("2023-12-31") > 0) {
            err_list.add_msg(new CHValid_Msg("dt_fim", "Data de Fim da Opera\u00e7\u00e3o n\u00e3o pode ser posterior a 2023-12-31"));
        }
        Date today = new Date();
        Date dt_inicio = CFType_Data.parse_date(this.getByName((String)"dt_inicio").v);
        Date dt_fim = CFType_Data.parse_date(this.getByName((String)"dt_fim").v);
        if (dt_inicio != null && dt_fim != null && dt_fim.before(dt_inicio)) {
            err_list.add_msg(new CHValid_Msg("dt_inicio", "Data de In\u00edcio n\u00e3o pode ser posterior \u00e0 Data de Fim da Opera\u00e7\u00e3o"));
        }
        return err_list;
    }

    CHValid_Grp validar_3(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Forma\u00e7\u00e3o");
        }
        this.extract();
        if (this.getByName((String)"formacao").v.equals("")) {
            err_list.add_msg(new CHValid_Msg("formacao", "Pretende apresentar um Programa de Forma\u00e7\u00e3o associado ao projeto? - %o"));
        }
        return err_list;
    }
}

