/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBRegisto_ActDescResult;
import fme.CBRegisto_ActDescricao;
import fme.CBTabela;
import fme.CBTabela_ActPrecedentes;
import fme.CBTabela_ActResultados;
import fme.CFLib;
import fme.CFType_Data;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CParseConfig;
import fme.CTabelas;
import fme.Frame_ActLista;
import fme.Frame_ActPrecedentes;
import fme.Frame_ActPrecedentes_N;
import fme.Frame_ActResultados;
import fme.Frame_ActResultados_N;
import fme.SteppedComboBox;
import fme.TabError;
import fme.TableKeyListener;
import fme.XMLDataHandler;
import fme._lib;
import fme.fmeApp;
import java.util.Date;
import java.util.Vector;
import javax.swing.JOptionPane;

class CBTabela_ActLista
extends CBTabela {
    Vector Lista_Descricao = new Vector();
    Vector Lista_ActPrecedentes = new Vector();
    Vector Lista_Resultados = new Vector();
    Vector Lista_DescResult = new Vector();
    Frame_ActLista PAG;
    public SteppedComboBox cboEntidades = null;
    public SteppedComboBox cboTipos = null;
    boolean col = !CBData.regime_op.matches("98|99");
    int xml_input_counter = -1;

    public String getPagina() {
        return "ActLista";
    }

    CBTabela_ActLista() {
        this.tag = "ActLista";
        this.PAG = (Frame_ActLista)fmeApp.Paginas.getPage("ActLista");
        if (this.PAG == null) {
            return;
        }
        this.initialize();
    }

    CBTabela_ActLista(Frame_ActLista p) {
        this.tag = "ActLista";
        this.PAG = p;
        this.initialize();
    }

    void initialize() {
        this.force_xml = true;
        this.started = true;
        this.cols = new CHTabColModel[11];
        this.cols[0] = new CHTabColModel("n_ordem", "N\u00ba da<br>Ativ.", true, false, true, null);
        this.cols[1] = new CHTabColModel("activ_d", "Designa\u00e7\u00e3o da Atividade", true, !this.col, true, null);
        this.cols[2] = new CHTabColModel("tipo_activ", "Tipo de<br>Atividade(id)", true, false, false, null);
        this.cols[3] = new CHTabColModel("tipo_activ_d", "Tipo de Atividade", false, true, true, null);
        this.cols[4] = new CHTabColModel("data_ini", "Data de<br>In\u00edcio", true, true, true, CFLib.VLD_DATA);
        this.cols[5] = new CHTabColModel("data_fim", "Data de<br>Fim", true, true, true, CFLib.VLD_DATA);
        this.cols[6] = new CHTabColModel("prioritaria", "Atividade<br>Priorit\u00e1ria?(id)", true, false, false, null);
        this.cols[7] = new CHTabColModel("prioritaria_d", "Atividade<br>Priorit\u00e1ria?", false, true, true, null);
        this.cols[8] = new CHTabColModel("coprom", "Entidade<br>Benefici\u00e1ria (id)", true, true, false, null);
        this.cols[9] = new CHTabColModel("coprom_d", "Entidade<br>Benefici\u00e1ria", false, true, true, null);
        this.cols[10] = new CHTabColModel("c_manut", "Custos de<br>Manuten\u00e7\u00e3o", true, true, this.col, CFLib.VLD_VALOR_0);
        this.init_dados(1);
        this.init_handler(this.PAG.getJTable_ActLista());
        this.PAG.getJTable_ActLista().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.PAG.getJScrollPane_ActLista().getWidth() - 20;
        this.handler.set_col_text(0, 0.06, "C");
        this.handler.set_col_text(1, 0.25, null);
        this.cboTipos = this.handler.set_col_comboF(3, 0.2, null, null, 1, CBData.regime_op.matches("98|99") ? 0 : 550);
        this.handler.set_col_text(4, 0.1, "C");
        this.handler.set_col_text(5, 0.1, "C");
        this.handler.set_col_comboS(7, 0.09, null, CTabelas.SimNao, 1, 55);
        this.cboEntidades = this.handler.set_col_comboS(9, 0.2, null, CTabelas.Empresas, 1, 280);
        if (this.col) {
            this.handler.set_col_text(10, 0.1, "R");
        }
        int i = 0;
        while (i < this.dados.size()) {
            this.adicionar_linha(i);
            ++i;
        }
    }

    public void Clear() {
        this.xml_input_counter = -1;
        super.Clear();
        while (this.dados.size() > 1) {
            this.del_activ(1);
            this.del_row_at(1);
        }
        this.handler.j.revalidate();
        this.handler.j.repaint();
    }

    void adicionar_linha(int n) {
        Frame_ActPrecedentes_N actT_N = (Frame_ActPrecedentes_N)fmeApp.Paginas.getPage("ActPrecedentes_N");
        Frame_ActPrecedentes actT = actT_N.nova_pagina(String.valueOf(n + 1) + " - ", n);
        this.Lista_Descricao.insertElementAt(new CBRegisto_ActDescricao(actT, n + 1), n);
        this.Lista_ActPrecedentes.insertElementAt(new CBTabela_ActPrecedentes(actT, n + 1), n);
        actT.getJTextField_Actividade().setEditable(false);
        Frame_ActResultados_N actS_N = (Frame_ActResultados_N)fmeApp.Paginas.getPage("ActResultados_N");
        Frame_ActResultados actS = actS_N.nova_pagina(String.valueOf(n + 1) + " - ", n);
        this.Lista_Resultados.insertElementAt(new CBTabela_ActResultados(actS, n + 1), n);
        this.Lista_DescResult.insertElementAt(new CBRegisto_ActDescResult(actS, n + 1), n);
        CBData.Params.on_update("ano_cand");
    }

    void on_row(int n) {
        if (n < 0) {
            return;
        }
        CTabelas.ActPrecedentes.refresh(n);
        this.PAG.getJTable_ActLista().getSelectionModel().setSelectionInterval(n, n);
        ((Frame_ActPrecedentes_N)fmeApp.Paginas.getPage((String)"ActPrecedentes_N")).jTabbedPane.setSelectedIndex(n);
        ((Frame_ActResultados_N)fmeApp.Paginas.getPage((String)"ActResultados_N")).jTabbedPane.setSelectedIndex(n);
    }

    boolean on_add_row() {
        int n = this.dados.size();
        if (!super.on_add_row()) {
            return false;
        }
        this.adicionar_linha(n);
        this.numerar(0);
        this.on_row(n);
        return true;
    }

    boolean on_copy_row() {
        return false;
    }

    boolean on_ins_row() {
        int n = this.handler.j.getSelectedRow();
        if (!super.on_ins_row(false)) {
            return false;
        }
        this.adicionar_linha(n);
        this.upd_tab_index(n + 1);
        this.numerar(0);
        this.on_row(n);
        return true;
    }

    boolean on_up_row() {
        return false;
    }

    void del_activ(int n) {
        this.Lista_Descricao.remove(n);
        this.Lista_ActPrecedentes.remove(n);
        this.Lista_Resultados.remove(n);
        this.Lista_DescResult.remove(n);
        ((Frame_ActPrecedentes_N)fmeApp.Paginas.getPage((String)"ActPrecedentes_N")).jTabbedPane.removeTabAt(n);
        ((Frame_ActResultados_N)fmeApp.Paginas.getPage((String)"ActResultados_N")).jTabbedPane.removeTabAt(n);
    }

    boolean on_del_row() {
        int n = this.handler.j.getSelectedRow();
        if (!super.on_del_row(true)) {
            return false;
        }
        this.del_activ(n);
        if (this.Lista_Descricao.size() < this.df_nlines) {
            this.adicionar_linha(this.dados.size() - 1);
        }
        this.upd_tab_index(n);
        this.actualizar();
        return true;
    }

    void numerar(int nCol) {
        int n = 1;
        int i = 0;
        while (i < this.dados.size()) {
            ((String[])this.dados.elementAt((int)i))[nCol] = Integer.toString(n++);
            ++i;
        }
    }

    void actualizar() {
        this.numerar(0);
        int i = 0;
        while (i < this.dados.size()) {
            this.actualizar(i);
            ++i;
        }
    }

    void actualizar(int nRow) {
        String nome = this.getColValue("activ_d", nRow);
        String small = nome.length() > 11 ? String.valueOf(nome.substring(0, 8)) + "..." : nome;
        Frame_ActPrecedentes_N actT_N = (Frame_ActPrecedentes_N)fmeApp.Paginas.getPage("ActPrecedentes_N");
        Frame_ActResultados_N actS_N = (Frame_ActResultados_N)fmeApp.Paginas.getPage("ActResultados_N");
        Frame_ActPrecedentes actT = ((CBRegisto_ActDescricao)this.Lista_Descricao.get((int)nRow)).PAG;
        actT.CBData_ActDescricao.getByName("activ_d").setStringValue(nome);
        actT.getJTextField_Actividade().setText(nome);
        actT_N.jTabbedPane.setToolTipTextAt(nRow, String.valueOf(nRow + 1) + " - " + nome);
        actS_N.jTabbedPane.setToolTipTextAt(nRow, String.valueOf(nRow + 1) + " - " + nome);
        actT_N.jTabbedPane.setTitleAt(nRow, String.valueOf(nRow + 1) + " - " + small);
        actS_N.jTabbedPane.setTitleAt(nRow, String.valueOf(nRow + 1) + " - " + small);
    }

    void upd_tab_labels() {
        int i = 0;
        while (i < this.dados.size()) {
            String _nome = this.getColValue("activ_d", i);
            String nome = _nome;
            if (nome.length() > 11) {
                nome = String.valueOf(_nome.substring(0, 8)) + "...";
            }
            Frame_ActPrecedentes actT = ((CBRegisto_ActDescricao)this.Lista_Descricao.get((int)i)).PAG;
            actT.CBData_ActDescricao.getByName("activ_d").setStringValue(_nome);
            actT.getJTextField_Actividade().setText(_nome);
            Frame_ActPrecedentes_N actT_N = (Frame_ActPrecedentes_N)fmeApp.Paginas.getPage("ActPrecedentes_N");
            actT_N.jTabbedPane.setToolTipTextAt(i, String.valueOf(i + 1) + " - " + _nome);
            actT_N.jTabbedPane.setTitleAt(i, String.valueOf(i + 1) + " - " + nome);
            Frame_ActResultados_N actS_N = (Frame_ActResultados_N)fmeApp.Paginas.getPage("ActResultados_N");
            actS_N.jTabbedPane.setToolTipTextAt(i, String.valueOf(i + 1) + " - " + _nome);
            actS_N.jTabbedPane.setTitleAt(i, String.valueOf(i + 1) + " - " + nome);
            ++i;
        }
    }

    void on_update(String colname, int nRow, String v) {
        int i;
        int j;
        CBTabela_ActPrecedentes act_prec;
        this.numerar(0);
        if (colname.equals("activ_d")) {
            String n_ordem = this.getColValue("n_ordem", nRow);
            int x = 0;
            while (x < CBData.ActLista.Lista_ActPrecedentes.size()) {
                act_prec = (CBTabela_ActPrecedentes)CBData.ActLista.Lista_ActPrecedentes.elementAt(x);
                j = 0;
                while (j < act_prec.dados.size()) {
                    String act = act_prec.getColValue("activ", j);
                    if (act.length() != 0 && act.equals(n_ordem)) {
                        act_prec.setColValue("activ_d", j, v);
                        act_prec.on_update("activ_d", j, v);
                    }
                    ++j;
                }
                ++x;
            }
            i = 0;
            while (i < CBData.QInv.dados.size()) {
                String act = CBData.QInv.getColValue("actividade", i);
                if (act.length() != 0 && act.equals(n_ordem)) {
                    CBData.QInv.setColValue("actividade_d", i, v);
                    CBData.QInv.on_update("actividade_d", i, v);
                }
                ++i;
            }
        }
        if (colname.equals("tipo_activ")) {
            String tipo_activ_d = "";
            if (v.equals("04")) {
                v = "";
            }
            if (v.length() > 0) {
                tipo_activ_d = CTabelas.TipoActiv.lookup(0, v, 1);
            }
            this.setColValue("tipo_activ_d", nRow, tipo_activ_d);
        }
        if (colname.equals("tipo_activ_d")) {
            String tipo_activ = "";
            if (v.length() > 0) {
                tipo_activ = CTabelas.TipoActiv.lookup(1, v, 0);
            }
            this.setColValue("tipo_activ", nRow, tipo_activ);
            if (this.col) {
                this.setColValue("activ_d", nRow, v);
                this.on_update("activ_d", nRow, v);
            }
        }
        if (colname.equals("prioritaria")) {
            String prioritaria_d = "";
            if (v.length() > 0) {
                prioritaria_d = CTabelas.SimNao.lookup(0, v, 1);
            }
            this.setColValue("prioritaria_d", nRow, prioritaria_d);
        }
        if (colname.equals("prioritaria_d")) {
            String prioritaria = "";
            if (v.length() > 0) {
                prioritaria = CTabelas.SimNao.lookup(1, v, 0);
            }
            this.setColValue("prioritaria", nRow, prioritaria);
        }
        if (colname.equals("data_ini") || colname.equals("data_fim")) {
            v = this.getColValue(colname, nRow);
            CBRegisto_ActDescricao act_desc = (CBRegisto_ActDescricao)CBData.ActLista.Lista_Descricao.elementAt(nRow);
            act_desc.getByName(colname).setStringValue(v);
            act_desc.on_update(colname);
            if (!CBData.reading_xml) {
                i = 0;
                while (i < this.dados.size()) {
                    act_prec = (CBTabela_ActPrecedentes)this.Lista_ActPrecedentes.elementAt(i);
                    j = 0;
                    while (j < act_prec.dados.size()) {
                        String activ = act_prec.getColValue("activ", j);
                        if (activ.equals(String.valueOf(nRow + 1))) {
                            act_prec.setColValue(colname, j, v);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        if (colname.equals("coprom_d")) {
            String coprom = "";
            if (v.length() > 0) {
                coprom = CTabelas.Empresas.lookup(1, v, 0);
            }
            this.setColValue("coprom", nRow, coprom);
        }
        if (colname.equals("coprom")) {
            String coprom_d = "";
            if (v.length() > 0) {
                coprom_d = CTabelas.Empresas.lookup(0, v, 1);
            }
            this.setColValue("coprom_d", nRow, coprom_d);
        }
        CTabelas.Actividades.refresh();
        CTabelas.ActPrecedentes.refresh(nRow);
        this.upd_tab_labels();
    }

    void _filter_populate_activs(SteppedComboBox cbo_subproj, int row) {
        int n;
        String tipo_act;
        String regime = CBData.DadosProjecto.getByName((String)"regime_op").v;
        String lst_subprojecto = "";
        if (regime.length() > 0 && !CParseConfig.hconfig.get("regime_op").toString().matches("98|99") && (tipo_act = CTabelas.RegimeOperacao.lookup(0, regime, 2)).equals("?")) {
            int i = 0;
            while (i < CBData.Subprojecto.dados.size()) {
                if (CBData.Subprojecto.getColValue("subprojecto", i).length() > 0) {
                    lst_subprojecto = String.valueOf(lst_subprojecto) + CBData.Subprojecto.getColValue("subprojecto", i).substring(1).toUpperCase() + "|";
                }
                ++i;
            }
        }
        lst_subprojecto = String.valueOf(lst_subprojecto) + "X";
        String tipo_activ = this.getColValue("tipo_activ", row);
        if (CBData.regime_op.matches("98|99")) {
            CTabelas.TipoActivF1.clear_filter();
            CTabelas.TipoActivF1._populateComboBox(cbo_subproj, 1);
            if (tipo_activ.length() > 0 && (n = CTabelas.TipoActivF1.getIndexFromCode(tipo_activ)) >= 0) {
                cbo_subproj.setSelectedIndex(n + 1);
            }
            return;
        }
        if (this.cboTipos != null) {
            if (regime.length() == 0) {
                cbo_subproj.removeAllItems();
                cbo_subproj.addItem("");
            } else {
                CTabelas.TipoActivF1.set_filter3(2, regime);
                CTabelas.TipoActivF1._populateComboBox(cbo_subproj, 1);
            }
            if (tipo_activ.length() > 0 && (n = CTabelas.TipoActivF1.getIndexFromCode(tipo_activ)) >= 0) {
                cbo_subproj.setSelectedIndex(n + 1);
            }
        }
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("tipo_activ")) {
            s = String.valueOf(s) + _lib.xml_encode("tipo_activ_d", this.getColValue("tipo_activ_d", row));
        }
        if (tag.equals("prioritaria")) {
            s = String.valueOf(s) + _lib.xml_encode("prioritaria_d", this.getColValue("prioritaria_d", row));
        }
        if (tag.equals("coprom")) {
            s = String.valueOf(s) + _lib.xml_encode("coprom_d", this.getColValue("coprom_d", row));
        }
        return s;
    }

    void upd_tab_index(int n) {
        int i = n;
        while (i < this.dados.size()) {
            CBRegisto_ActDescricao desc_act = (CBRegisto_ActDescricao)this.Lista_Descricao.elementAt(i);
            desc_act.index = i + 1;
            CBTabela_ActPrecedentes tarefa = (CBTabela_ActPrecedentes)this.Lista_ActPrecedentes.elementAt(i);
            tarefa.index = i + 1;
            CBTabela_ActResultados miles = (CBTabela_ActResultados)this.Lista_Resultados.elementAt(i);
            miles.upd_index(i + 1);
            CBRegisto_ActDescResult miles_d = (CBRegisto_ActDescResult)this.Lista_DescResult.elementAt(i);
            miles_d.index = i + 1;
            ++i;
        }
    }

    boolean del_ins_ok(String option) {
        this.handler.__garbage_stop_editing();
        int n = this.handler.j.getSelectedRow();
        int m = this.handler.j.getRowCount();
        boolean emp_ok = false;
        String msg = "";
        String n_ordem = this.getColValue("n_ordem", n);
        if (n_ordem.length() > 0) {
            int j = 0;
            while (j < CBData.QInv.dados.size()) {
                String act = CBData.QInv.getColValue("actividade", j);
                if (act.length() > 0 && Integer.parseInt(act) >= Integer.parseInt(n_ordem)) {
                    emp_ok = true;
                    msg = "J\u00e1 existem linhas no Quadro de Investimentos definidas para a Atividade com o N\u00ba " + n_ordem + " ou superior.\n" + "Imposs\u00edvel " + option + " Linha!";
                    break;
                }
                ++j;
            }
            if (emp_ok) {
                JOptionPane.showMessageDialog(null, msg, String.valueOf(option) + " Linha", 0, null);
                return false;
            }
        }
        return true;
    }

    String xmlPrintInternal(int row) {
        String xml = "";
        xml = String.valueOf(xml) + "<Descricao>\n";
        xml = String.valueOf(xml) + ((CBRegisto_ActDescricao)this.Lista_Descricao.elementAt(row)).xmlPrint();
        xml = String.valueOf(xml) + "</Descricao>\n";
        xml = String.valueOf(xml) + "<Precedentes>\n";
        xml = String.valueOf(xml) + ((CBTabela_ActPrecedentes)this.Lista_ActPrecedentes.elementAt(row)).xmlPrint();
        xml = String.valueOf(xml) + "</Precedentes>\n";
        xml = String.valueOf(xml) + "<Resultados>\n";
        xml = String.valueOf(xml) + ((CBTabela_ActResultados)this.Lista_Resultados.elementAt(row)).xmlPrint();
        xml = String.valueOf(xml) + "</Resultados>\n";
        xml = String.valueOf(xml) + "<DescResult>\n";
        xml = String.valueOf(xml) + ((CBRegisto_ActDescResult)this.Lista_DescResult.elementAt(row)).xmlPrint();
        xml = String.valueOf(xml) + "</DescResult>\n";
        return xml;
    }

    public void xmlBegin(String path) {
        if (path.endsWith("/ActLista/Reg")) {
            ++this.xml_input_counter;
            if (this.dados.size() < this.xml_input_counter + 1) {
                this.on_add_row();
            }
            super.xmlBegin(path);
        }
    }

    public XMLDataHandler getHandler(String path) {
        if (path.endsWith("/Descricao")) {
            return (CBRegisto_ActDescricao)this.Lista_Descricao.elementAt(this.xml_input_counter);
        }
        if (path.endsWith("/Precedentes")) {
            return (CBTabela_ActPrecedentes)this.Lista_ActPrecedentes.elementAt(this.xml_input_counter);
        }
        if (path.endsWith("/Resultados")) {
            return (CBTabela_ActResultados)this.Lista_Resultados.elementAt(this.xml_input_counter);
        }
        if (path.endsWith("/DescResult")) {
            return (CBRegisto_ActDescResult)this.Lista_DescResult.elementAt(this.xml_input_counter);
        }
        return null;
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Identifica\u00e7\u00e3o das Atividades da Opera\u00e7\u00e3o");
        }
        if (!this.started) {
            return err_list;
        }
        if (this.isEmpty()) {
            err_list.add_msg(new CHValid_Msg("actlista", "Lista vazia"));
        } else {
            Date dt_inicio_op = CFType_Data.parse_date(CBData.DadosProjecto.getByName((String)"dt_inicio").v);
            Date dt_fim_op = CFType_Data.parse_date(CBData.DadosProjecto.getByName((String)"dt_fim").v);
            int j = 0;
            while (j < this.dados.size()) {
                StringBuffer mask = new StringBuffer("-R-RRR-R-R-");
                String tipo_activ = this.getColValue("tipo_activ", j);
                if (!tipo_activ.equals("") && this.col && CTabelas.TipoActiv.lookup(0, tipo_activ, 5).equals("X")) {
                    mask.setCharAt(this.getColIndex("c_manut"), 'R');
                }
                TabError[] e = this.isIncompletAll(j, mask.toString());
                int ii = 0;
                while (e != null && ii < e.length) {
                    err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o")));
                    ++ii;
                }
                Date dt_inicio = CFType_Data.parse_date(this.getColValue("data_ini", j));
                Date dt_fim = CFType_Data.parse_date(this.getColValue("data_fim", j));
                if (dt_inicio != null && dt_inicio_op != null && dt_inicio_op.after(dt_inicio)) {
                    err_list.add_msg(new CHValid_Msg("dt_inicio", "Linha " + (j + 1) + ": A Data de In\u00edcio da Atividade n\u00e3o pode ser anterior \u00e0 Data de In\u00edcio da Opera\u00e7\u00e3o"));
                }
                if (dt_fim != null && dt_fim_op != null && dt_fim.after(dt_fim_op)) {
                    err_list.add_msg(new CHValid_Msg("dt_inicio", "Linha " + (j + 1) + ": A Data de Fim da Atividade n\u00e3o pode ser posterior \u00e0 Data de Fim da Opera\u00e7\u00e3o"));
                }
                if (dt_inicio != null && dt_fim != null && dt_inicio.after(dt_fim)) {
                    err_list.add_msg(new CHValid_Msg("dt_inicio", "Linha " + (j + 1) + ": A Data de In\u00edcio n\u00e3o pode ser posterior \u00e0 Data de Fim"));
                }
                ++j;
            }
            if (!this.isUnique("tipo_activ") && !CBData.regime_op.matches("98|99")) {
                err_list.add_msg(new CHValid_Msg("dt_inicio", "N\u00e3o podem existir Tipos de Atividade repetidos"));
            }
        }
        return err_list;
    }
}

