/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_Formandos;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeApp;

class CBTabela_FormandosInt
extends CBTabela {
    Frame_Formandos P = (Frame_Formandos)fmeApp.Paginas.getPage("Formandos");
    int limite = 9000;

    public String getPagina() {
        return "Formandos";
    }

    CBTabela_FormandosInt() {
        if (this.P == null) {
            return;
        }
        this.initialize();
    }

    void initialize() {
        this.tag = "FormandosInt";
        this.cols = new CHTabColModel[9];
        this.cols[0] = new CHTabColModel("n_ordem", "N\u00ba", true, false, true, null);
        this.cols[1] = new CHTabColModel("design", "Designa\u00e7\u00e3o", true, true, true, null);
        this.cols[2] = new CHTabColModel("rbm", "RBM", true, true, true, CFLib.VLD_VALOR);
        this.cols[3] = new CHTabColModel("n_prest", "N\u00ba<br>Presta\u00e7\u00f5es<br>Anuais", true, true, true, CFLib.VLD_PREST_ANUAL);
        this.cols[4] = new CHTabColModel("n_horas", "N\u00ba<br>Horas<br>Semanais", true, true, true, CFLib.VLD_HORAS_SEMANA);
        this.cols[5] = new CHTabColModel("custo_hora", "Custo/Hora", true, false, true, CFLib.VLD_VALOR);
        this.cols[6] = new CHTabColModel("desfavorecido", "c/ defici\u00eancia<br>ou desfavo-<br>recidos (id)", true, true, false, null);
        this.cols[7] = new CHTabColModel("desfavorecido_d", "c/ defici\u00eancia<br>ou desfavo-<br>recidos", false, true, true, null);
        this.cols[8] = new CHTabColModel("nivel", "N\u00edvel", true, true, true, null);
        this.init_dados(6);
        this.init_handler(this.P.getJTable_FormandosInt());
        this.P.getJTable_FormandosInt().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.P.getJScrollPane_FormandosInt().getWidth();
        String[] nivel = new String[]{"", "1", "2", "3", "4", "5", "6", "7", "8"};
        this.handler.set_col_text(0, 0.065, "C");
        this.handler.set_col_text(1, 0.32, null);
        this.handler.set_col_text(2, 0.1, "R");
        this.handler.set_col_text(3, 0.11, "R");
        this.handler.set_col_text(4, 0.1, "R");
        this.handler.set_col_text(5, 0.1, "R");
        this.handler.set_col_comboS(7, 0.12, "C", CTabelas.SimNao, 1, 0);
        this.handler.set_col_comboL(8, 0.06, "C", nivel, 1, 0);
        this.started = true;
    }

    void on_update(String colname, int nRow, String v) {
        this.numerar(0);
        if (colname.matches("rbm|n_prest|n_horas")) {
            double rbm = _lib.to_double(this.getColValue("rbm", nRow));
            double n_prest = _lib.to_double(this.getColValue("n_prest", nRow));
            double n_horas = _lib.to_double(this.getColValue("n_horas", nRow));
            double custo_hora = 0.0;
            if (n_horas > 0.0) {
                custo_hora = _lib.round(rbm * n_prest / (48.0 * n_horas));
            }
            this.setColValue("custo_hora", nRow, custo_hora > 0.0 ? String.valueOf(custo_hora) : "");
        }
        if (colname.equals("desfavorecido_d")) {
            String desfavorecido = "";
            if (v.length() > 0) {
                desfavorecido = CTabelas.SimNao.lookup(1, v, 0);
            }
            this.setColValue("desfavorecido", nRow, desfavorecido);
        }
        if (colname.equals("desfavorecido")) {
            String desfavorecido_d = "";
            if (v.length() > 0) {
                desfavorecido_d = CTabelas.SimNao.lookup(0, v, 1);
            }
            this.setColValue("desfavorecido_d", nRow, desfavorecido_d);
        }
    }

    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("desfavorecido")) {
            s = String.valueOf(s) + _lib.xml_encode("desfavorecido_d", this.getColValue("desfavorecido_d", row));
        }
        return s;
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        String titulo = "Lista de Formandos Internos/Perfis";
        if (err_list == null) {
            err_list = new CHValid_Grp(this, titulo);
        }
        if (!this.started) {
            return err_list;
        }
        int i = 0;
        while (i < this.dados.size()) {
            StringBuffer mask = new StringBuffer("-RRRRR-RR");
            TabError[] e = this.isIncompletAll(i, mask.toString());
            int ii = 0;
            while (e != null && ii < e.length) {
                err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o")));
                ++ii;
            }
            ++i;
        }
        return err_list;
    }
}

