/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CHTabQuadro;
import fme.CHTabela;
import fme.CParse;
import fme.CParseConfig;
import fme.Http;
import fme.XMLParser;
import fme.fmeApp;
import fme.fmeComum;
import fme.fmeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class CadastroConnection
extends JDialog {
    public static final String serverURL = String.valueOf(fmeComum.atend_pas) + "acesso/formulario/atend-import.php";
    private JTextField jText_nif = null;
    private JTextField jText_pwd = null;
    private JButton jButton_go = null;
    private JButton jButton_in = null;
    private JLabel jText_help = null;
    private Document doc = null;
    private static final String green_check = "<span style='color:green'>&#160;&#160;&#160;&#10004;&#160;&#160;</span>";
    private static final long serialVersionUID = 1L;

    CadastroConnection() {
        this.setModal(true);
        this.setSize(494, 390);
        this.setResizable(false);
        this.setTitle("Importar dados da PAS - Plataforma de Acesso Simplificado");
        JLabel jlbl_logo = new JLabel(new ImageIcon(fmeFrame.class.getResource("pas_logo.png")));
        jlbl_logo.setBounds(new Rectangle(250, 10, 216, 90));
        JLabel jlbl_nif = new JLabel("NIF:");
        jlbl_nif.setHorizontalAlignment(4);
        jlbl_nif.setBounds(new Rectangle(0, 25, 66, 18));
        this.jText_nif = new JTextField();
        this.jText_nif.setBounds(new Rectangle(70, 25, 140, 18));
        if (!CBData.reg_C.equals("") && !CBData.reg_nif.equals("")) {
            this.jText_nif.setText(CBData.reg_nif);
            this.jText_nif.setEditable(false);
            this.jText_nif.setFocusable(false);
        }
        JLabel jlbl_pwd = new JLabel("Password:");
        jlbl_pwd.setHorizontalAlignment(4);
        jlbl_pwd.setBounds(new Rectangle(0, 55, 66, 18));
        this.jText_pwd = new JPasswordField();
        this.jText_pwd.setBounds(new Rectangle(70, 55, 140, 18));
        this.jText_help = new JLabel();
        this.jText_help.setBackground((Color)UIManager.get("TextField.disabledBackground"));
        this.jText_help.setForeground((Color)UIManager.get("TextField.disabledForeground"));
        this.jText_help.setBorder(new LineBorder(new Color(200, 200, 200)));
        this.jText_help.setBounds(new Rectangle(15, 130, 460, 218));
        this.jText_help.setHorizontalAlignment(2);
        this.jText_help.setVerticalAlignment(1);
        this.jButton_go = new JButton("Login");
        this.jButton_go.setBounds(new Rectangle(90, 90, 100, 24));
        this.jButton_go.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CadastroConnection.this.enable_face(false);
                new do_connect().start();
            }
        });
        this.jButton_in = new JButton("Importar");
        this.jButton_in.setBounds(new Rectangle(70, 90, 140, 24));
        this.jButton_in.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent v) {
                Object[] options = new Object[]{"   Sim   ", "   N\u00e3o   "};
                if (JOptionPane.showOptionDialog(null, "A informa\u00e7\u00e3o importada ir\u00e1 sobrepor qualquer informa\u00e7\u00e3o existente.\n\nQuer continuar?", "Importar", 0, 3, null, options, options[1]) != 0) {
                    return;
                }
                try {
                    CBData.__garbage_stop_editing();
                    XPath xp = XPathFactory.newInstance().newXPath();
                    for (XMLParser.xml_tag_handler th : fmeApp.cb.xml_dh.tlist) {
                        if (!(th.handler instanceof CBTabela) || xp.evaluate(th.path, CadastroConnection.this.doc, XPathConstants.NODE) == null) continue;
                        CBTabela cbt = (CBTabela)th.handler;
                        if (cbt.handler instanceof CHTabQuadro) {
                            int n = 0;
                            while (n < cbt.cols.length) {
                                if (cbt.cols[n].editable && xp.evaluate(String.valueOf(th.path) + "/Reg/" + cbt.cols[n].col_tag, CadastroConnection.this.doc, XPathConstants.NODE) != null) {
                                    int i = 0;
                                    while (i < cbt.dados.size()) {
                                        ((String[])cbt.dados.elementAt((int)i))[n] = "";
                                        ++i;
                                    }
                                }
                                ++n;
                            }
                            continue;
                        }
                        if (!(cbt.handler instanceof CHTabela)) continue;
                        cbt.Clear();
                    }
                    CBData.import_pas = true;
                    DOMSource source = new DOMSource(CadastroConnection.this.doc);
                    StringWriter xmlWriter = new StringWriter();
                    StreamResult result = new StreamResult(xmlWriter);
                    TransformerFactory.newInstance().newTransformer().transform(source, result);
                    InputSource input = new InputSource(new StringReader(xmlWriter.toString()));
                    SAXParserFactory.newInstance().newSAXParser().parse(input, (DefaultHandler)new CParse());
                    CadastroConnection.this.dispose();
                    CBData.import_pas = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CadastroConnection.this.jText_help.setText(CadastroConnection.this.html("N\u00e3o foi poss\u00edvel importar da Plataforma de Acesso Simplificado:\n\n" + e.getLocalizedMessage()));
                }
            }
        });
        this.setLayout(null);
        this.add(jlbl_logo);
        this.add(jlbl_nif);
        this.add(jlbl_pwd);
        this.add(this.jText_nif);
        this.add(this.jText_pwd);
        this.add(this.jButton_go);
        this.add(this.jButton_in);
        this.add(this.jText_help);
    }

    public void showDialog(Component parent) {
        if (!CBData.reg_C.equals("") && CBData.reg_pas.equals("1")) {
            this.enable_face(false);
            System.out.println("connect");
            new do_connect().start();
        }
        if (parent != null) {
            this.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.getSize().width / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - this.getSize().height / 2);
        }
        this.jText_help.setText(this.html("Bem-vindo \u00e0 funcionalidade de importa\u00e7\u00e3o de dados a partir do seu perfil registado na PAS.\n\nCaso ainda n\u00e3o tenha efetuado o registo na PAS, poder\u00e1 faz\u00ea-lo clicando no logo acima.\n\n\nPara importar os seus dados dever\u00e1 colocar o seu NIF e a Password de acesso utilizada na PAS, premindo de seguida na tecla \u201cLogin\u201d."));
        this.jButton_go.setVisible(true);
        this.jButton_in.setVisible(false);
        this.setModal(true);
        this.setVisible(true);
        this.enable_face(true);
    }

    private void enable_face(boolean e) {
        if (!CBData.reg_C.equals("") && !CBData.reg_nif.equals("")) {
            this.jText_nif.setText(CBData.reg_nif);
            this.jText_nif.setEditable(false);
            this.jText_nif.setFocusable(false);
        } else {
            this.jText_nif.setEditable(e);
            this.jText_nif.setFocusable(e);
        }
        this.jText_pwd.setEditable(e);
        this.jText_pwd.setFocusable(e);
        this.jButton_go.setEnabled(e);
        this.revalidate();
        this.repaint();
    }

    private String html(String txt) {
        return "<html><div style='padding:6px'>" + txt.replaceAll("\\n", "<br>") + "</div></html>";
    }

    private class do_connect
    extends Thread {
        private do_connect() {
        }

        public void run() {
            try {
                System.setProperty("java.net.useSystemProxies", "true");
                String nif = CadastroConnection.this.jText_nif.getText();
                String pwd = CadastroConnection.this.jText_pwd.getText();
                String xml = "<?xml version='1.0' encoding='ISO-8859-1'?>";
                xml = String.valueOf(xml) + "<iRequest>\n";
                xml = String.valueOf(xml) + "<PAS>\n";
                xml = String.valueOf(xml) + "<reg_c>" + CBData.reg_C + "</reg_c>\n";
                xml = String.valueOf(xml) + "<reg_nif>" + CBData.reg_nif + "</reg_nif>\n";
                xml = String.valueOf(xml) + "<reg_pas>" + CBData.reg_pas + "</reg_pas>\n";
                xml = String.valueOf(xml) + "<aviso>" + CParseConfig.hconfig.get("aviso").toString() + "</aviso>\n";
                xml = String.valueOf(xml) + "<nif>" + nif + "</nif>\n";
                xml = String.valueOf(xml) + "<pwd>" + pwd + "</pwd>\n";
                xml = String.valueOf(xml) + "</PAS>\n";
                xml = String.valueOf(xml) + "</iRequest>\n";
                Http http = new Http(serverURL);
                CadastroConnection.this.doc = http.doPostRequestDoc(xml);
                XPath xp = XPathFactory.newInstance().newXPath();
                String status = xp.evaluate("//fme/Login/status", CadastroConnection.this.doc);
                String msg = xp.evaluate("//fme/Login/msg", CadastroConnection.this.doc);
                if (!status.equals("OK")) {
                    CadastroConnection.this.jText_help.setText(CadastroConnection.this.html("N\u00e3o foi poss\u00edvel obter dados na Plataforma de Acesso Simplificado:\n\n" + msg));
                    CadastroConnection.this.enable_face(true);
                    return;
                }
                NodeList lista = (NodeList)xp.evaluate("//fme/Lista/Reg", CadastroConnection.this.doc, XPathConstants.NODESET);
                if (lista.getLength() == 0) {
                    CadastroConnection.this.jText_help.setText(CadastroConnection.this.html("N\u00e3o existe informa\u00e7\u00e3o dispon\u00edvel para as credenciais apresentadas"));
                } else {
                    msg = "Atualmente est\u00e3o dispon\u00edveis na Plataforma de Acesso Simplificado, os seguintes dados:\n\n";
                    int i = 0;
                    while (i < lista.getLength()) {
                        String design = xp.evaluate("design", lista.item(i));
                        design = design.replaceAll("\\s*\\(\\)\\s*$", "");
                        msg = String.valueOf(msg) + CadastroConnection.green_check + design + "\n";
                        ++i;
                    }
                    msg = String.valueOf(msg) + "\nPrima a tecla de \u201cimportar\u201d para confirmar a importa\u00e7\u00e3o da informa\u00e7\u00e3o.";
                    CadastroConnection.this.jButton_go.setVisible(false);
                    CadastroConnection.this.jButton_in.setVisible(true);
                    CadastroConnection.this.jText_help.setText(CadastroConnection.this.html(msg));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                CadastroConnection.this.enable_face(true);
                CadastroConnection.this.jText_help.setText(CadastroConnection.this.html("N\u00e3o foi poss\u00edvel contactar a Plataforma de Acesso Simplificado:\n\n" + e.getLocalizedMessage()));
            }
        }
    }
}

