/*
 * Decompiled with CFR 0.152.
 */
package fme;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

class Http {
    private HttpURLConnection httpConn;
    int timeout = 0;

    Http(String requestURL) {
        this(requestURL, 0);
    }

    Http(String requestURL, int timeout) {
        this.timeout = timeout;
        try {
            URL url = new URL(requestURL);
            this.httpConn = (HttpURLConnection)url.openConnection();
            this.httpConn.setUseCaches(false);
            if (timeout > 0) {
                this.httpConn.setConnectTimeout(timeout);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.httpConn.setDoInput(true);
        this.httpConn.setDoOutput(true);
    }

    public String doPostRequest(File f) {
        try {
            byte[] result = new byte[(int)f.length()];
            int totalBytesRead = 0;
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(f));
            while (totalBytesRead < result.length) {
                int bytesRemaining = result.length - totalBytesRead;
                int bytesRead = ((InputStream)input).read(result, totalBytesRead, bytesRemaining);
                if (bytesRead <= 0) continue;
                totalBytesRead += bytesRead;
            }
            ((InputStream)input).close();
            BufferedOutputStream writer = new BufferedOutputStream(this.httpConn.getOutputStream());
            ((OutputStream)writer).write(result);
            ((OutputStream)writer).flush();
            InputStream inputStream = this.httpConn.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            String resp = "";
            String line = "";
            while ((line = reader.readLine()) != null) {
                resp = String.valueOf(resp) + line;
            }
            reader.close();
            return resp;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String doPostRequest(String s) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(this.httpConn.getOutputStream());
            writer.write(s);
            writer.flush();
            InputStream inputStream = this.httpConn.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            String resp = "";
            String line = "";
            while ((line = reader.readLine()) != null) {
                resp = String.valueOf(resp) + line;
            }
            reader.close();
            return resp;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String doPostRequest(ByteArrayOutputStream s) {
        try {
            BufferedOutputStream writer = new BufferedOutputStream(this.httpConn.getOutputStream());
            ((OutputStream)writer).write(s.toByteArray());
            ((OutputStream)writer).flush();
            InputStream inputStream = this.httpConn.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            String resp = "";
            String line = "";
            while ((line = reader.readLine()) != null) {
                resp = String.valueOf(resp) + line;
            }
            reader.close();
            return resp;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public Document doPostRequestDoc(String s) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(this.httpConn.getOutputStream());
            writer.write(s);
            writer.flush();
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.httpConn.getInputStream());
        }
        catch (Exception exception) {
            return null;
        }
    }

    static boolean ping(String url) {
        Http http = new Http(url, 1000);
        String s = http.doPostRequest("ping");
        return s.equals("(reply)");
    }

    static Proxy teste_proxy(String uri) {
        List<Proxy> lista = null;
        try {
            System.setProperty("java.net.useSystemProxies", "true");
            lista = ProxySelector.getDefault().select(new URI(uri));
        }
        catch (Exception e) {
            return null;
        }
        if (lista != null) {
            Iterator<Proxy> iter = lista.iterator();
            if (iter.hasNext()) {
                Proxy proxy = iter.next();
                return proxy;
            }
        } else {
            return null;
        }
        return null;
    }
}

