/*
 * Decompiled with CFR 0.152.
 */
package fme;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

class TreeTextArea
extends JTextArea {
    Dimension preferredSize;

    TreeTextArea() {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setOpaque(true);
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public void setPreferredSize(Dimension d) {
        if (d != null) {
            this.preferredSize = d;
        }
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void setText(String str) {
        Vector resultado = new Vector();
        int maxWidth = 415;
        JPanel pn = new JPanel();
        FontMetrics fm = pn.getFontMetrics(this.getFont());
        resultado = this.quebraLinhas(this.getFont(), str, maxWidth);
        int lines = resultado.toArray().length;
        lines = lines >= 1 ? lines : 1;
        int height = fm.getHeight() * lines;
        this.setPreferredSize(new Dimension(maxWidth + 6, height));
        str = "";
        int i = 0;
        while (i < lines) {
            str = String.valueOf(str) + resultado.elementAt(i);
            ++i;
        }
        super.setText(str);
    }

    void setSelect(boolean isSelected) {
        Color bColor = isSelected ? UIManager.getColor(Color.GREEN) : UIManager.getColor(Color.BLUE);
        super.setBackground(bColor);
    }

    void setFocus(boolean hasFocus) {
        if (hasFocus) {
            Color lineColor = UIManager.getColor("Tree.selectionBorderColor");
            this.setBorder(BorderFactory.createLineBorder(lineColor));
        } else {
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
    }

    public Vector quebraLinhas(Font fonte, String texto, int largura) {
        Vector<String> resultado = new Vector<String>();
        JPanel metrica = new JPanel();
        if (fonte == null || texto == null || texto.length() == 0) {
            return resultado;
        }
        if (largura <= 0) {
            largura = 415;
        }
        String esta = "";
        String anterior = "";
        if (texto.lastIndexOf("\n") < 0) {
            StringTokenizer trataString = new StringTokenizer(texto);
            while (trataString.hasMoreTokens()) {
                String parte = trataString.nextToken();
                esta = esta.length() == 0 ? parte : String.valueOf(esta) + " " + parte;
                if (metrica.getFontMetrics(fonte).stringWidth(esta) > largura) {
                    resultado.addElement(new String(String.valueOf(anterior) + "\n"));
                    esta = parte;
                }
                anterior = esta;
            }
            if (anterior.length() > 0) {
                resultado.addElement(new String(String.valueOf(anterior) + "\n"));
            }
        } else {
            StringTokenizer trataString = new StringTokenizer(texto, "\n");
            while (trataString.hasMoreTokens()) {
                resultado.addElement(new String(trataString.nextToken()));
            }
        }
        return resultado;
    }
}

